package gov.va.vinci.dart.db.impl;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.EventType;
import gov.va.vinci.dart.db.EventTypeDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;

public class EventTypeDAOImpl extends HibernateDAO implements EventTypeDAO {
	
	@Override
	public EventType findById(final int eventTypeId) throws ObjectNotFoundException {
		Query q = createQuery("from EventType where id=:eventTypeId");
		q.setParameter("eventTypeId", eventTypeId);
		try {
			return (EventType)q.getSingleResult();
		}
		catch (NoResultException e) {
			throw new ObjectNotFoundException(e);
		}
		catch (NonUniqueResultException e) {
			throw new ObjectNotFoundException(e);
		}
	}

	@Override
	public EventType findByName(final String name) throws ObjectNotFoundException {
		
		Query query = createQuery("from EventType where name like :pname");
		query.setParameter("pname", name);
		try {
			return (EventType)query.getSingleResult();
		} catch (NoResultException e) {
			throw new ObjectNotFoundException(e);
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<EventType> listAll() {
		Query query = createQuery("from EventType");
		return (List<EventType>)query.getResultList();
	}
}
